/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.HustleGame;

public class SettingsScreen
implements Screen {
    private HustleGame game;
    private Stage optionStage;
    private OrthographicCamera camera;
    private Viewport viewport;
    private Window optionMenu;
    public Slider musicSlider;
    public Slider sfxSlider;
    public Screen previousScreen;

    public SettingsScreen(final HustleGame game, final Screen previousScreen) {
        this.game = game;
        this.previousScreen = previousScreen;
        this.optionStage = new Stage(new FitViewport(game.WIDTH, game.HEIGHT));
        Gdx.input.setInputProcessor(this.optionStage);
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.WIDTH, (float)game.HEIGHT, this.camera);
        this.camera.setToOrtho(false, game.WIDTH, game.HEIGHT);
        this.optionMenu = new Window("", game.skin);
        this.optionStage.addActor(this.optionMenu);
        this.optionMenu.setModal(true);
        Table optionTable = new Table();
        this.optionMenu.add(optionTable).prefHeight(600.0f);
        TextButton exitButton = new TextButton("Exit", game.skin);
        Label title = new Label("Settings", game.skin, "button");
        Label musicTitle = new Label("Music Volume", game.skin, "interaction");
        this.musicSlider = new Slider(0.0f, 100.0f, 1.0f, false, game.skin, "default-horizontal");
        Label sfxTitle = new Label("SFX Volume", game.skin, "interaction");
        this.sfxSlider = new Slider(0.0f, 100.0f, 1.0f, false, game.skin, "default-horizontal");
        Table sliderTable = new Table();
        this.musicSlider.setValue(game.soundManager.getMusicVolume() * 100.0f);
        this.sfxSlider.setValue(game.soundManager.getSfxVolume() * 100.0f);
        sliderTable.add(musicTitle).padRight(20.0f);
        sliderTable.add(this.musicSlider).prefWidth(250.0f);
        sliderTable.row().padTop(20.0f);
        sliderTable.add(sfxTitle).padRight(20.0f).right();
        sliderTable.add(this.sfxSlider).prefWidth(250.0f);
        optionTable.add(title).top().padTop(40.0f).padBottom(50.0f);
        optionTable.row();
        optionTable.add(sliderTable).fillX();
        optionTable.row();
        optionTable.add(exitButton).pad(40.0f, 50.0f, 60.0f, 50.0f).width(300.0f).bottom().expandY();
        this.optionMenu.pack();
        this.optionMenu.setSize(600.0f, 600.0f);
        this.optionMenu.setX(this.viewport.getWorldWidth() / 2.0f - this.optionMenu.getWidth() / 2.0f);
        this.optionMenu.setY(this.viewport.getWorldHeight() / 2.0f - this.optionMenu.getHeight() / 2.0f);
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                SettingsScreen.this.dispose();
                game.setScreen(previousScreen);
                previousScreen.resume();
            }
        });
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.game.blueBackground.draw();
        this.optionStage.act(delta);
        this.optionStage.draw();
        this.game.soundManager.setMusicVolume(this.musicSlider.getValue() / 100.0f);
        this.game.soundManager.setSfxVolume(this.sfxSlider.getValue() / 100.0f);
        this.camera.update();
    }

    @Override
    public void resize(int width, int height) {
        this.optionStage.getViewport().update(width, height);
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
        this.optionStage.dispose();
    }
}

