/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.skloch.game.GameObject;

public class Player {
    public Rectangle sprite;
    public Rectangle feet;
    public Rectangle eventHitbox;
    public float centreX;
    public float centreY;
    public int direction = 2;
    private TextureRegion currentFrame;
    private float stateTime = 0.0f;
    private final Array<Animation<TextureRegion>> walkingAnimation;
    private final Array<Animation<TextureRegion>> idleAnimation;
    public float speed = 300.0f;
    public Array<GameObject> collidables;
    public int scale = 4;
    private Rectangle bounds;
    private GameObject closestObject;
    public boolean frozen;
    public boolean moving;

    public Player(String avatar) {
        TextureAtlas playerAtlas = new TextureAtlas(Gdx.files.internal("Sprites/Player/player_sprites.atlas"));
        this.walkingAnimation = new Array();
        this.idleAnimation = new Array();
        this.walkingAnimation.add(new Animation<TextureAtlas.AtlasRegion>(0.25f, playerAtlas.findRegions(avatar + "_walk_back"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.25f, playerAtlas.findRegions(avatar + "_walk_right"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.25f, playerAtlas.findRegions(avatar + "_walk_front"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.25f, playerAtlas.findRegions(avatar + "_walk_left"), Animation.PlayMode.LOOP));
        this.idleAnimation.add(new Animation<TextureAtlas.AtlasRegion>(0.4f, playerAtlas.findRegions(avatar + "_idle_back"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.4f, playerAtlas.findRegions(avatar + "_idle_right"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.4f, playerAtlas.findRegions(avatar + "_idle_front"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.4f, playerAtlas.findRegions(avatar + "_idle_left"), Animation.PlayMode.LOOP));
        this.collidables = new Array();
        this.sprite = new Rectangle(0.0f, 0.0f, 17 * this.scale, 28 * this.scale);
        this.feet = new Rectangle(4 * this.scale, 0.0f, 9 * this.scale, 7 * this.scale);
        float hitboxScaleX = 2.2f;
        float hitboxScaley = 1.7f;
        this.eventHitbox = new Rectangle(this.sprite.getX() - (this.sprite.getWidth() * hitboxScaleX - this.sprite.getWidth()) / 2.0f, this.sprite.getY() - (this.sprite.getHeight() * hitboxScaley - this.sprite.getHeight()) / 2.0f, this.sprite.getWidth() * hitboxScaleX, this.sprite.getHeight() * hitboxScaley);
    }

    public void move(float delta) {
        this.moving = false;
        float oldX = this.sprite.x;
        float oldY = this.sprite.y;
        float oldFeetX = this.feet.x;
        if (!this.frozen) {
            this.moving = false;
            if (Gdx.input.isKeyPressed(21) || Gdx.input.isKeyPressed(29)) {
                this.setX(this.sprite.getX() - this.speed * delta);
                this.direction = 3;
                this.moving = true;
            }
            if (Gdx.input.isKeyPressed(22) || Gdx.input.isKeyPressed(32)) {
                this.setX(this.sprite.getX() + this.speed * delta);
                this.direction = 1;
                this.moving = true;
            }
            if (Gdx.input.isKeyPressed(19) || Gdx.input.isKeyPressed(51)) {
                this.setY(this.sprite.getY() + this.speed * delta);
                this.direction = 0;
                this.moving = true;
            }
            if (Gdx.input.isKeyPressed(20) || Gdx.input.isKeyPressed(47)) {
                this.setY(this.sprite.getY() - this.speed * delta);
                this.direction = 2;
                this.moving = true;
            }
            for (GameObject object : this.collidables) {
                if (!this.feet.overlaps(object)) continue;
                if (!(oldFeetX < object.x + object.width) || !(oldFeetX + this.feet.width > object.x)) {
                    this.setX(oldX);
                }
                if (oldY < object.y + object.height && oldY + this.feet.height > object.y) continue;
                this.setY(oldY);
            }
            if (this.bounds != null) {
                if (this.feet.getX() < this.bounds.getX()) {
                    this.sprite.x = this.bounds.getX() - (float)(4 * this.scale);
                    this.feet.x = this.sprite.x + (float)(4 * this.scale);
                }
                if (this.feet.getX() + this.feet.getWidth() > this.bounds.getWidth()) {
                    this.sprite.x = this.bounds.getWidth() - this.feet.getWidth() - (float)(4 * this.scale);
                    this.feet.x = this.sprite.x + (float)(4 * this.scale);
                }
                if (this.feet.getY() < this.bounds.getY()) {
                    this.sprite.y = this.bounds.getY();
                    this.feet.y = this.bounds.getY();
                }
                if (this.feet.getY() + this.feet.getHeight() > this.bounds.getHeight()) {
                    this.feet.y = this.sprite.y = this.bounds.getHeight() - this.feet.getHeight();
                }
            }
        }
        this.recalcCentre();
        float distance = -1.0f;
        this.closestObject = null;
        for (GameObject object : this.collidables) {
            if (object.get("event") == null && object.get("text") == null || !this.eventHitbox.overlaps(object) || distance != -1.0f && !(this.distanceFrom(object) < distance)) continue;
            this.closestObject = object;
            distance = this.distanceFrom(object);
        }
        this.updateAnimation();
    }

    public void updateAnimation() {
        this.stateTime += Gdx.graphics.getDeltaTime();
        this.currentFrame = this.moving ? this.walkingAnimation.get(this.direction).getKeyFrame(this.stateTime) : this.idleAnimation.get(this.direction).getKeyFrame(this.stateTime);
    }

    public boolean nearObject() {
        return this.closestObject != null;
    }

    public GameObject getClosestObject() {
        return this.closestObject;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public TextureRegion getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCollidables(Array<GameObject> collidables) {
        this.collidables = collidables;
    }

    public void addCollidable(GameObject object) {
        this.collidables.add(object);
    }

    public float getX() {
        return this.sprite.getX();
    }

    public float getY() {
        return this.sprite.getY();
    }

    public float getCentreX() {
        return this.centreX;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public Vector3 getPosAsVec3() {
        return new Vector3(this.sprite.getX(), this.sprite.getY(), 0.0f);
    }

    public void setX(float x) {
        this.sprite.setX(x);
        this.feet.setX(x + (float)(4 * this.scale));
        this.eventHitbox.setX(this.sprite.getX() - (this.eventHitbox.getWidth() - this.sprite.getWidth()) / 2.0f);
        this.recalcCentre();
    }

    public void setY(float y) {
        this.sprite.setY(y);
        this.feet.setY(y);
        this.eventHitbox.setY(this.sprite.getY() - (this.eventHitbox.getHeight() - this.sprite.getHeight()) / 2.0f);
        this.recalcCentre();
    }

    public void setPos(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    private float distanceFrom(GameObject object) {
        return (float)Math.sqrt(Math.pow(this.centreX - object.centreX, 2.0) + Math.pow(this.centreY - object.centreY, 2.0));
    }

    private void recalcCentre() {
        this.centreX = this.sprite.getX() + this.sprite.getWidth() / 2.0f;
        this.centreY = this.sprite.getY() + this.sprite.getHeight() / 2.0f;
    }

    public void setFrozen(boolean freeze) {
        this.frozen = freeze;
        if (freeze) {
            this.currentFrame = this.idleAnimation.get(this.direction).getKeyFrame(this.stateTime);
        }
    }

    public boolean isFrozen() {
        return this.frozen;
    }
}

