/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.HustleGame;

public class CreditScreen
implements Screen {
    private HustleGame game;
    private Stage creditStage;
    private OrthographicCamera camera;
    private Viewport viewport;

    public CreditScreen(final HustleGame game, final Screen previousScreen) {
        this.game = game;
        this.creditStage = new Stage(new FitViewport(game.WIDTH, game.HEIGHT));
        Gdx.input.setInputProcessor(this.creditStage);
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.WIDTH, (float)game.HEIGHT, this.camera);
        this.camera.setToOrtho(false, game.WIDTH, game.HEIGHT);
        Window creditMenu = new Window("", game.skin);
        this.creditStage.addActor(creditMenu);
        creditMenu.setModal(true);
        Table creditTable = new Table();
        creditMenu.add(creditTable).prefHeight(600.0f);
        Label title = new Label("Credits", game.skin, "button");
        creditTable.add(title).padTop(10.0f);
        creditTable.row();
        Table scrollTable = new Table();
        ScrollPane scrollWindow = new ScrollPane((Actor)scrollTable, game.skin);
        scrollWindow.setFadeScrollBars(false);
        creditTable.add(scrollWindow).padTop(20.0f).height(350.0f);
        creditTable.row();
        Label text = new Label(game.credits, game.skin, "interaction");
        text.setWrap(true);
        scrollTable.add(text).width(520.0f).padLeft(15.0f);
        TextButton exitButton = new TextButton("Exit", game.skin);
        creditTable.add(exitButton).bottom().width(300.0f).padTop(10.0f);
        creditMenu.pack();
        creditMenu.setSize(600.0f, 600.0f);
        creditMenu.setX(this.viewport.getWorldWidth() / 2.0f - creditMenu.getWidth() / 2.0f);
        creditMenu.setY(this.viewport.getWorldHeight() / 2.0f - creditMenu.getHeight() / 2.0f);
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                game.soundManager.playButton();
                CreditScreen.this.dispose();
                game.setScreen(previousScreen);
                previousScreen.resume();
            }
        });
    }

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.game.blueBackground.draw();
        this.creditStage.act(delta);
        this.creditStage.draw();
        this.camera.update();
    }

    @Override
    public void resize(int width, int height) {
        this.creditStage.getViewport().update(width, height);
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

